/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.security.crypto;

import de.willuhn.jameica.security.crypto.Engine;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import java.io.InputStream;
import java.io.OutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;

public class RSAEngine
implements Engine {
    @Override
    public void encrypt(InputStream is, OutputStream os) throws Exception {
        Logger.debug((String)"creating cipher");
        Cipher cipher = Cipher.getInstance("RSA", "BC");
        cipher.init(1, Application.getSSLFactory().getPublicKey());
        Logger.debug((String)"encrypting data");
        int size = cipher.getBlockSize();
        Logger.debug((String)("using block size (in bytes): " + size));
        byte[] buf = new byte[size];
        int read = 0;
        do {
            if ((read = is.read(buf)) <= 0) continue;
            os.write(cipher.doFinal(buf, 0, read));
        } while (read != -1);
    }

    @Override
    public void decrypt(InputStream is, OutputStream os) throws Exception {
        Logger.debug((String)"creating cipher");
        Cipher cipher = Cipher.getInstance("RSA", "BC");
        cipher.init(2, Application.getSSLFactory().getPrivateKey());
        int size = cipher.getBlockSize();
        Logger.debug((String)("using block size (in bytes): " + size));
        Logger.debug((String)"decrypting data");
        byte[] buf = new byte[size];
        int read = 0;
        do {
            if ((read = is.read(buf)) <= 0) continue;
            os.write(cipher.doFinal(buf, 0, read));
        } while (read != -1);
    }

    @Override
    public InputStream decrypt(InputStream is) throws Exception {
        Logger.debug((String)"creating cipher");
        Cipher cipher = Cipher.getInstance("RSA", "BC");
        cipher.init(1, Application.getSSLFactory().getPublicKey());
        return new CipherInputStream(is, cipher);
    }

    @Override
    public OutputStream encrypt(OutputStream os) throws Exception {
        Logger.debug((String)"creating cipher");
        Cipher cipher = Cipher.getInstance("RSA", "BC");
        cipher.init(2, Application.getSSLFactory().getPrivateKey());
        return new CipherOutputStream(os, cipher);
    }
}

